// XISLActTag.cpp: CXISLActTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLDialogTag.h"
#include "XISLActTag.h"
#include "XISLOutputBrowser.h"
#include "XISLCombOutputTag.h"
#include "XISLCallTag.h"
#include "XISLExitTag.h"
#include "XISLAssignTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLActTag::CXISLActTag()
{
}
CXISLActTag::CXISLActTag(CXISLTag *pParent,BOOL bExcAct)
{
	m_pParentTag = pParent;

	m_nTagType = ID_TAG_ACTION;
	m_rectNextBMP = CRect(0,0,0,0);
	m_bExcAct = bExcAct;
	m_pExitTag = NULL;
}

CXISLActTag::~CXISLActTag()
{
	for(int i=0;i<m_ActionList.GetCount();i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
		delete pActItem;
	}
	if(m_pExitTag!=NULL)
		delete m_pExitTag;
}

CXISLActTag::CXISLActTag(const CXISLActTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_ActionList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_ActionList.FindIndex(i);
		m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
	}
	m_bExcAct = cpXISL.m_bExcAct;
	m_pExitTag = cpXISL.m_pExitTag;
	m_rectNextBMP = cpXISL.m_rectNextBMP;
}

CXISLActTag& CXISLActTag::operator=(const CXISLActTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0;i<m_ActionList.GetCount();i++)
		{
			POSITION pos = m_ActionList.FindIndex(i);
			CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
			delete pActItem;
		}
		m_ActionList.RemoveAll();
		for(i=0; i<cpXISL.m_ActionList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_ActionList.FindIndex(i);
			m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
		}
		m_bExcAct = cpXISL.m_bExcAct;
		m_pExitTag = cpXISL.m_pExitTag;
		m_rectNextBMP = cpXISL.m_rectNextBMP;
	}
	return *this;
}


//LPCTSTR CXISLActTag::GetXISLString()
//@\@FactionȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLActTag::GetXISLString()
{
	m_strXISL.Empty();
	if(m_bExcAct)
	{
		m_strXISL = "<";
		m_strXISL += XISL_TAG_NAME[m_nTagType];
		m_strXISL += ">\r\n";

		if(m_ActionList.IsEmpty())
		{
			m_strXISL += "</";
			m_strXISL += XISL_TAG_NAME[m_nTagType];
			m_strXISL += ">\r\n";
			return m_strXISL;
		}
	}

	for(int i=0;i<m_ActionList.GetCount();i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
		m_strXISL += pActItem->GetXISLString();
	}

	if(m_pExitTag)
		m_strXISL += m_pExitTag->GetXISLString();
	if(m_bExcAct)
	{
		m_strXISL += "</";
		m_strXISL += XISL_TAG_NAME[m_nTagType];
		m_strXISL += ">\r\n";
	}
	return m_strXISL;
}

//int CXISLActTag::GetItemCount()
//@\@FactionȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLActTag::GetItemCount()
{
	int nCount = 0;
	if((nCount = m_ActionList.GetCount()) != 0)
	{
		if(m_bExcAct)
			nCount++;  //<action>̕
	}

	return nCount;
}

BOOL CXISLActTag::HasExit()
{
	if(m_pExitTag)
		return TRUE;
	else
		return FALSE;
}

CXISLExitTag* CXISLActTag::SetExit(BOOL bExit)
{
	if(bExit)
	{
		if(m_pExitTag)
			return m_pExitTag;
		m_pExitTag = new CXISLExitTag;
		m_pExitTag->m_pParentTag = m_pParentTag;
		return m_pExitTag;
	}
	else
	{
		if(m_pExitTag)
		{
			delete m_pExitTag;
			m_pExitTag = NULL;
		}
		return NULL;
	}
}

//ACeǉ
void CXISLActTag::InsertActItem(CXISLActItem *pTag)
{
	m_ActionList.AddTail(pTag);
	pTag->m_pParentTag = m_pParentTag;
}

//폜
//2003/5/15@
BOOL CXISLActTag::DeleteActItem(CXISLActItem *pTag)
{
	POSITION pos = m_ActionList.Find(pTag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	m_ActionList.RemoveAt(posdel);
	delete pTag;
	pTag=NULL;
	return TRUE;
}

//SWitch^O̍폜
//2003/5/16@
BOOL CXISLActTag::DeleteSwitch(CXISLSwitchTag *pSTag)
{
	//Xg^Öʒu擾
	POSITION pos = m_ActionList.Find(pSTag);
	//΃G[
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	//Case^OSč폜
	pSTag->DeleteItemIntoCase();
	//Switch^O폜
	m_ActionList.RemoveAt(posdel);
	delete pSTag;
	pSTag=NULL;
	return TRUE;

}

//If^O̍폜
//2003/6/2@
BOOL CXISLActTag::DeleteIf(CXISLIfTag *pIfTag)
{
	//Xg^Öʒu擾
	POSITION pos = m_ActionList.Find(pIfTag);
	//΃G[
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	//Case^OSč폜
	pIfTag->DeleteALL();
	//Switch^O폜
	m_ActionList.RemoveAt(posdel);
	delete pIfTag;
	pIfTag=NULL;
	return TRUE;
}

//BOOL CXISLActTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLActTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	if(m_bExcAct)
	{
		//c[ɓo^
		tvi.pszText = XISL_TAG_NAME[m_nTagType];
		tvi.lParam = (LPARAM)this;
		tvi.iImage = 0;
		tvi.iSelectedImage = 1;
		tvs.item = tvi;
		hParent = pTree->InsertItem(&tvs);
		m_htreeItem = hParent;
	}
	for(int i=0; i<m_ActionList.GetCount(); i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);

		pActItem->RegistXISLTree(pTree,hParent);
	}

	if(m_pExitTag)
		m_pExitTag->RegistXISLTree(pTree,hParent);

	return TRUE;
}

/*
CXISLOutputBrowser* CXISLActTag::CreateOutputBrowser(int nType,int nEvent,LPCTSTR lpszWName,LPCTSTR lpszParam,int nParam)
{
	CXISLOutputBrowser *pOutputTag;
	switch(nEvent)
	{
	case ID_BROWSEREVENT_CLOSE:
	case ID_BROWSEREVENT_MAX:
	case ID_BROWSEREVENT_MIN:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName);
		break;
	case ID_BROWSEREVENT_MOVE:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,nParam);
		break;
	case ID_BROWSEREVENT_OPEN:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,nParam,lpszParam);
		break;
	case ID_BROWSEREVENT_NAVI:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,lpszParam);
		break;
	default:
		return NULL;
	}

	m_ActionList.AddTail(pOutputTag);

	return pOutputTag;
}
*/
//CSize CXISLActTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Faction̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLActTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->MoveTo(nX,nY);
	nY += 10;
	pDC->LineTo(nX,nY);

	int nCount = m_ActionList.GetCount();
	if((nCount == 0) && (m_pExitTag == NULL))
		return CSize(nX,nY);

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;
	CBitmap *pOldBMP;
	
	CFont *pOldFont;
	CFont font;
	font.CreateFont(12,0,0,0,FW_BOLD,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
		DRAFT_QUALITY,DEFAULT_PITCH,_T("lr oSVbN"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetTextColor(RGB(80,80,80));
	pDC->SetBkMode(TRANSPARENT);

	CString strText;
	for(int i=0;i<nCount;i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);

		FlowBMP.LoadBitmap(pActItem->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		if(i==0)
		{
			pOldBMP = MemDC.SelectObject(&FlowBMP);
			pDC->MoveTo(nX,nY);
			nY += 10;
			pDC->LineTo(nX,nY);
		}
		else
			MemDC.SelectObject(&FlowBMP);

		pDC->MoveTo(nX,nY);
		nY += 20;
		pDC->LineTo(nX,nY);

		pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		pActItem->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
		if(pActItem->m_nTagType == ID_TAG_ASSIGN)
		{
			strText = ((CXISLAssignTag*)pActItem)->GetName();
			CString strExpr = "l:\n";

			CRect rect;
			pActItem->GetRectBMP(&rect);
			rect.top += 10;
			pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP);
			rect.top -= 5;
			rect.left=rect.right;
			rect.right += 100;
			strExpr += ((CXISLAssignTag*)pActItem)->GetExpr();
			pDC->DrawText(strExpr,rect,DT_NOCLIP|DT_PATH_ELLIPSIS);
		}
		else if(pActItem->m_nTagType == ID_TAG_SWITCH )
		{
			strText = ((CXISLSwitchTag*)pActItem)->GetExpr();
			CRect rect;
			pActItem->GetRectBMP(&rect);
			pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
		}
		else if(pActItem->m_nTagType ==ID_TAG_IF || pActItem->m_nTagType ==ID_TAG_ELSEIF)
		{
			strText = ((CXISLIfTag*)pActItem)->GetCond();
			CRect rect;
			pActItem->GetRectBMP(&rect);
			pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
		}
		else if(pActItem->m_nTagType == ID_TAG_OUTPUT)
		{
			((CXISLOutputTag*)pActItem)->GetDrawString(strText);
			CRect rect;
			pActItem->GetRectBMP(&rect);
			rect.left = rect.right;
			rect.right += 100;
			pDC->DrawText(strText,rect,DT_NOCLIP|DT_PATH_ELLIPSIS);
		}

		//`
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		nY += bmp.bmHeight;
	}

	if(m_pExitTag)
	{
		FlowBMP.LoadBitmap(m_pExitTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		if(nCount==0)
		{
			pOldBMP = MemDC.SelectObject(&FlowBMP);
			pDC->MoveTo(nX,nY);
			nY += 10;
			pDC->LineTo(nX,nY);
		}
		else
			MemDC.SelectObject(&FlowBMP);
		pDC->MoveTo(nX,nY);
		nY += 20;
		pDC->LineTo(nX,nY);

		pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		m_pExitTag->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);

		//`
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		nY += bmp.bmHeight;
	}
	
	nViewSizeX = nX + bmp.bmWidth/2;
	nViewSizeY = nY;
	pDC->SelectObject(pOldFont);
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX,nViewSizeY);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLActTag::FindTag(POINT point,BOOL bOnly)
{
	CXISLTag* pTag;
	for(int i=0;i<m_ActionList.GetCount();i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem* pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);

		pTag = pActItem->FindTag(point,bOnly);
		if(pTag)
			return pTag;
	}

	if(m_pExitTag)
		return m_pExitTag->FindTag(point,bOnly);

	return NULL;
}
